-----------------------------------------------------------------------------
--                                                                         --
-- Copyright (c) 1994 by Altera Corp.  All rights reserved.                --
--                                                                         --
--                                                                         --
--  Description:  This file contains macro function A_8FADD                --
--                                                                         --
--                                                                         --
--                                                                         --
-----------------------------------------------------------------------------
library pack1076;
use pack1076.pack1076.all;

library synth;
use synth.stdsynth.all;

entity A_8FADD is
        port (A8, A7, A6, A5, A4, A3, A2, A1 : in VLBIT;
              B8, B7, B6, B5, B4, B3, B2, B1 : in VLBIT;
              CIN : in VLBIT;
              SUM8, SUM7, SUM6, SUM5, SUM4, SUM3, SUM2, SUM1, COUT : out VLBIT);
end A_8FADD;
 
architecture BEHAVIOR of A_8FADD is
        constant SIZE : integer := 7;
begin
FADD: process (A8,A7,A6,A5,A4,A3,A2,A1,B8,B7,B6,B5,B4,B3,B2,B1,CIN)
        variable ABUS: VLBIT_VECTOR(SIZE downto 0);
        variable BBUS: VLBIT_VECTOR(SIZE downto 0);
        variable SUMBUS : VLBIT_VECTOR(SIZE downto 0);
        variable carry : VLBIT;
    begin
        carry := CIN;
        ABUS := (A8&A7&A6&A5&A4&A3&A2&A1);
        BBUS := (B8&B7&B6&B5&B4&B3&B2&B1);

        for k in 0 to 7 loop
            SUMBUS(k) := ABUS(k) xor BBUS(k) xor carry;
            carry := (ABUS(k) and BBUS(k)) or (carry and (ABUS(k) or BBUS(k)));
        end loop;
   
        COUT <= (ABUS(7) and BBUS(7)) or (carry and (ABUS(7) or BBUS(7)));


        SUM1 <= SUMBUS(0);
        SUM2 <= SUMBUS(1);
        SUM3 <= SUMBUS(2);
        SUM4 <= SUMBUS(3);
        SUM5 <= SUMBUS(4);
        SUM6 <= SUMBUS(5);
        SUM7 <= SUMBUS(6);
        SUM8 <= SUMBUS(7);
end process FADD;
 
end BEHAVIOR;

